#include "descriptor/descriptor.h"
#include <stdio.h>
int main(void)
{
	ITEM scene, light1, g9, asta, base, spessore, appoggio1, appoggio2;
	ITEM metallo,  vetroBianco, ceramica, legnoScuro, legnoMenoScuro,  rame, vernice, parquet1, dorato, vetro, vetroLampadario;
	ITEM bicchiere[2], gamba[4], stanza, pavimento, soffitto, retroQuadro, cornice, vetroQuadro, lampadario;
	int i;
	char name[6];

	/*LUCE*/
	set_background(0.8,0.8,0.8,TRUE);
	set_ambient_light(1,1,1,2.5);
	light1 = create_point_light(0,0,14,1,1,1,1.5 ,100000,  "light1");

	/*ATTRIBUTO METALLO*/
	metallo = create_attribute("metallo");
	set_color(metallo,0.72,0.72,0.72,0.1,0.9);
	set_reflectivity(metallo,0.5,300);

	/*ATTRIBUTO RAME*/
	rame = create_attribute("rame");
	set_color(rame, 1.0, 0.3, 0.0, 0.1, 0.9);
	set_reflectivity(rame, 0.5, 200);


	/*ATTRIBUTO VETRO BIANCO*/
	vetroBianco = create_attribute("vetroBianco");
	set_color(vetroBianco, 0.68, 0.85, 1, 0.5, 0.5);
	set_reflectivity(vetroBianco, 0.24, 1);
	set_transparency(vetroBianco, 0.87, 0.7, 1, 1.5);

	/*ATTRIBUTO VETRO*/
	vetro = create_attribute("vetro");
	set_color(vetro, 1, 1, 1, 0.2, 0.3);
	set_reflectivity(vetro, 0.3, 1.5);
	set_transparency(vetro, 1, 0.9,0.2, 2);

	/*ATTRIBUTO VETRO LAMPADARIO*/
	vetroLampadario = create_attribute("vetroLampadario");
	set_color(vetroLampadario, 0.7, 0.65, 0.4, 0.7, 0.85);
	set_reflectivity(vetroLampadario, 0.8, 1);
	set_transparency(vetroLampadario, 0.7, 0.5, 1, 1.5);

	/*ATTRIBUTO CERAMICA*/
	ceramica = create_attribute("ceramica");
	set_color(ceramica, 0.75, 0.6, 0.5, 0.1, 0.75);
	set_reflectivity(ceramica, 0.1, 150);


	/*ATTRIBUTO LEGNO SCURO*/
	legnoScuro = create_attribute("legnoScuro");
	set_color(legnoScuro, 0.55, 0.4, 0.3, 0.1, 0.8);
	set_reflectivity(legnoScuro, 0.1, 100);

	/*ATTRIBUTO LEGNO MENO SCURO*/
	legnoMenoScuro = create_attribute("legnoMenoScuro");
	set_color(legnoMenoScuro, 0.6, 0.4, 0.3, 0.1, 0.8);
	set_reflectivity(legnoMenoScuro, 0.1, 100);

	/*ATTRIBUTO VERNICE*/
	vernice = create_attribute("vernice");
	set_color(vernice, 0.55, 0.5, 0.3, 0.1, 0.8);
	set_reflectivity(vernice, 0, 10);

	/*ATTRIBUTO PARQUET1*/
	parquet1 = create_attribute("parquet1");
	set_color(parquet1, 1, 0.7, 0.4, 0.1, 0.7);
	set_reflectivity(parquet1, 0.05, 25);

	/*ATTRIBUTO DORATO*/
	dorato = create_attribute("dorato");
	set_color(dorato, 0.7, 0.8, 0.3, 0.1, 0.8);
	set_reflectivity(dorato, 0.1, 50);

	g9 = read_obj("provaResa.obj", "g9");
	set_attribute(g9, metallo);
	set_translate(g9, 0, 0, 1.3);

	asta = read_nurbs("astaPiedistallo.db");
	set_attribute(asta, rame);
	set_scale(asta, 2.0, 2.0, 3);
	set_translate(asta, -2,0, -3.5);

	base = read_nurbs("base.db");
	set_attribute(base, ceramica);
	set_scale(base, 3, 3, 3);
	set_translate(base, -2, 0, -3.5);


	bicchiere[0] = read_nurbs("bicchiere.db");
	set_attribute(bicchiere[0], vetroBianco);
	set_scale_abs(bicchiere[0], 3, 3, 3);
	set_translate(bicchiere[0], -4, -4, -6.5);

	bicchiere[1] = read_nurbs("bicchiere.db");
	set_attribute(bicchiere[1], vetroBianco);
	set_scale_abs(bicchiere[1], 3, 3, 3);
	set_translate(bicchiere[1], 8, 7, -6.8);

	spessore = read_nurbs("spessoreTavolo.db");
	set_wood_texture(spessore, legnoScuro, legnoMenoScuro);
	set_scale_abs(spessore, 2, 2, 2);
	set_translate(spessore, 0.05, 0, -31.6);

	appoggio1 = read_nurbs("appoggioTav.db");
	set_wood_texture(appoggio1, legnoScuro, legnoMenoScuro);
	set_scale_abs(appoggio1, 2, 2, 2);
	set_translate(appoggio1, 0, 0, -31.5);

	appoggio2 = read_nurbs("appoggioTav2.db");
	set_wood_texture(appoggio2, legnoScuro, legnoMenoScuro);
	set_scale_abs(appoggio2, 2, 2, 2);
	set_translate(appoggio2, 0,0, -31.7);

	gamba[0] = read_nurbs("gamba1.db");

	for(i=1; i<4; i++){
		sprintf(name, "gamba%i", i+1);
		gamba[i] = create_copy(gamba[0], name);
	}

	for(i=0; i<4;i++){
		set_scale_abs(gamba[i], 1, 1, 1.5);
		set_wood_texture(gamba[i], legnoScuro, legnoMenoScuro);
		set_translate(gamba[i], 0, 0, -26.5);
	}


	 set_translate(gamba[0], -15, -8, 0);
	 set_translate(gamba[1], -15, 8, 0);
	 set_translate(gamba[2], 5.5, -8, 0);
	 set_translate(gamba[3], 5.5, 8, 0);

	stanza = read_nurbs("corpostanza.db");
	set_scale_abs(stanza, 50, 200, 200);
	set_y_rotate(stanza, 90, 1);
	set_attribute(stanza, vernice);
	set_translate(stanza, 0, 0 , 25);

	pavimento = read_nurbs("lato1.db");
	set_scale_abs(pavimento, 200, 200, 200);
	set_y_rotate(pavimento, 90, 1);
	set_translate(pavimento, 0,0, -25);
	set_domain_texture(pavimento, parquet1, "textures/parquet2.hr", 0, 0.15, 0, 0.15, 1,0.2, 0.1);

	soffitto = read_nurbs("lato2.db");
	set_scale_abs(soffitto, 200, 200, 200);
	set_y_rotate(soffitto, 90, 1);
	set_attribute(soffitto, vernice);
	set_translate(soffitto, 0, 0, 225);

	cornice = read_nurbs("cornice.db");
	set_scale(cornice, 15, 15, 15);
	set_z_rotate(cornice, -90, 1);
	set_translate(cornice, -98.5, 0, 0);
	set_attribute(cornice, dorato);

	retroQuadro = read_nurbs("retroquadro.db");
	set_scale(retroQuadro, 15, 15, 15);
	set_z_rotate(retroQuadro, -90, 1);
	set_translate(retroQuadro, -98.5, 0, 0);
	set_domain_texture(retroQuadro, vernice, "textures/delisle.hr", 0, 0.3, 0, 1,1, 0.2, 0.5);

	vetroQuadro = read_nurbs("vetroquadro.db");
	set_scale(vetroQuadro, 15, 15, 15);
	set_z_rotate(vetroQuadro, -90, 1);
	set_translate(vetroQuadro, -98.5, 0, 0);
	set_attribute(vetroQuadro, vetro);

	lampadario = read_nurbs("lampadario.db");
	set_scale(lampadario, 15, 15, 12);
	set_translate(lampadario, 0,0, 16.7);
	set_attribute(lampadario, vetroLampadario);

	/*SCENA*/
	scene = create_list(g9, "scene");
	scene = insert_in_list(scene, asta);
	scene = insert_in_list(scene, base);
	scene = insert_in_list(scene, bicchiere[0]);
	scene = insert_in_list(scene, bicchiere[1]);
	scene = insert_in_list(scene, spessore);
	scene = insert_in_list(scene, appoggio1);
	scene = insert_in_list(scene, appoggio2);
	for(i=0; i<4; i++)
		scene = insert_in_list(scene, gamba[i]);
	scene = insert_in_list(scene, stanza);
	scene = insert_in_list(scene, pavimento);
	scene = insert_in_list(scene, cornice);
	scene = insert_in_list(scene, retroQuadro);
	scene = insert_in_list(scene, vetroQuadro);
	scene = insert_in_list(scene, lampadario);
	scene = insert_in_list(scene, soffitto);
	save_scene("aereo.md","g9",scene);
        return(0);

}
