/* b52.c */

#include "descriptor/descriptor.h"
#include <stdio.h>

int main(void) {

	// OGGETTI DELLA SCENA
	ITEM tettoHangar, pavimentoHangar, portoneHangar, paretiHangar, facciateHangar;
	ITEM motori_missili_supporti, gomme, fusoliera_ali_timoni, carrelli_cerchioni, particolari, telaio, parabrezza;
	ITEM pavimentoEsterno,scenarioEsterno;
	ITEM hangar;
	ITEM aereo;
	ITEM scena;
	ITEM esterno;

	// ATTRIBUTI DELLA SCENA
	ITEM metallo1;			//metallo fusoliera, timoni, particolari, motori, missili etc.
	ITEM metallo2;			//metallo carrelli, cerchioni, etc.
	ITEM metallo3;			//metallo tetto hangar
	ITEM metallo4;			//metallo portone e pareti hangar
	ITEM cemento, gomma, vetro;

	// LUCI DELLA SCENA
	ITEM luce01,luce02;

	set_background(0.675,0.855,1,TRUE);
	set_ambient_light(0.9,0.9,0.9,2.5);
	luce01 = create_point_light(5.5,0,3,1,1,1,2,1000, "luce01");
	luce02 = create_point_light(-9.5,0,3,1,1,1,2,1000, "luce02");


	// ATTRIBUTI Metalli
	metallo1 = create_attribute("metallo1");
	set_color(metallo1,0.5,0.5,0.5,0.5,0.5);
	set_reflectivity(metallo1,0.1,128);

	metallo2 = create_attribute("metallo2");
	set_color(metallo2,0.7,0.7,0.7,0.1,0.449);
	set_reflectivity(metallo2,0.1,128);

	metallo3 = create_attribute("metallo3");
	set_color(metallo3,0.4,0.4,0.4,0.1,0.1);
	set_reflectivity(metallo3,0,50);

	metallo4 = create_attribute("metallo4");
	set_color(metallo4,0.8,0.8,0.8,0.1,0.1);
	set_reflectivity(metallo4,0,50);


	// ATTRIBUTI Cemento
	cemento = create_attribute("cemento");
	set_color(cemento,0.83,0.82,0.8,0.1,0.697);
	set_reflectivity(cemento,0,12);


	// ATTRIBUTI Gomma
	gomma = create_attribute("gomma");
	set_color(gomma,0.1,0.1,0.1,0.1,0.697);
	set_reflectivity(gomma,0,1);

	// ATTRIBUTI Vetro
	vetro = create_attribute("vetro");
	set_color(vetro,0,0.2,0.8,0.1,0.5);
	set_reflectivity(vetro,0.2,0.4);	

	//FUSOLIERA_ALI_TIMONI
	fusoliera_ali_timoni= read_obj("fusoliera_ali_timoni.obj", "fusoliera_ali_timoni");
	set_attribute(fusoliera_ali_timoni,metallo1);
	set_domain_texture(fusoliera_ali_timoni, metallo1, "textures/camo.hr",0,1,0,1,1,0.4,0.5);


	//MOTORI_MISSILI_SUPPORTI
	motori_missili_supporti= read_obj("motori_missili_supporti.obj", "motori_missili_supporti");
	set_attribute(motori_missili_supporti,metallo1);
	set_domain_texture(motori_missili_supporti, metallo1, "textures/camo.hr",0,1,0,1,1,0.4,0.5);


	//CARRELLI_CERCHIONI
	carrelli_cerchioni= read_obj("carrelli_cerchioni.obj", "carrelli_cerchioni");
	set_attribute(carrelli_cerchioni,metallo2);

	//GOMME
	gomme= read_obj("gomme.obj", "gomme");
	set_attribute(gomme,gomma);

	//PARTICOLARI
	particolari= read_obj("particolari.obj", "particolari");
	set_attribute(particolari,metallo1);
	set_domain_texture(particolari, metallo1, "textures/camo.hr",0,1,0,1,1,0.4,0.5);

	//TELAIO
	telaio= read_obj("telaio_parabrezza.obj","telaio");
	set_attribute(telaio,metallo1);
	set_domain_texture(telaio, metallo1, "textures/camo.hr",0,1,0,1,1,0.4,0.5);
	
	//PARABREZZA
	parabrezza= read_obj("parabrezza.obj","parabrezza");
	set_attribute(parabrezza,vetro);

	//AEREO (B52)
	aereo = create_list(fusoliera_ali_timoni,"aereo");
	aereo = insert_in_list(aereo,motori_missili_supporti);
	aereo = insert_in_list(aereo,carrelli_cerchioni);
	aereo = insert_in_list(aereo,particolari);
	aereo = insert_in_list(aereo,gomme);
	//aereo = insert_in_list(aereo,telaio);
	aereo = insert_in_list(aereo,parabrezza);


	//TETTO_HANGAR
	tettoHangar= read_obj("tetto_hangar.obj","tettoHangar");
	set_attribute(tettoHangar,metallo3);
	set_domain_texture(tettoHangar, metallo3, "textures/tetto.hr",0,0.1,0,0.1,1,1,1);

	//PAVIMENTO_HANGAR
	pavimentoHangar= read_obj("pavimento_hangar.obj","pavimentoHangar");
	set_attribute(pavimentoHangar,cemento);
	set_domain_texture(pavimentoHangar, cemento, "textures/pavimento.hr",0,0.2,0,0.2,1,0.2,0.3);

	//PORTONE_HANGAR
	portoneHangar= read_obj("portone_hangar.obj","portoneHangar");
	set_attribute(portoneHangar,metallo4);
	set_domain_texture(portoneHangar, metallo4, "textures/portone.hr",0,0.2,0,0.2,1,0.2,0.3);

	//PARETI_HANGAR
	paretiHangar= read_obj("pareti_hangar.obj","paretiHangar");
	set_attribute(paretiHangar,metallo4);
	set_domain_texture(paretiHangar, metallo4, "textures/pareti_verticali.hr",0,1,0,0.1,1,0.2,0.3);

	//FACCIATE_HANGAR
	facciateHangar= read_obj("facciate_hangar.obj","facciateHangar");
	set_attribute(facciateHangar,metallo4);
	set_domain_texture(facciateHangar, metallo4, "textures/pareti_orizzontali.hr",0,0.1,0,1,1,0.2,0.3);

	//HANGAR
	hangar = create_list(pavimentoHangar,"hangar");
	hangar = insert_in_list(hangar,tettoHangar);
	hangar = insert_in_list(hangar,portoneHangar);
	hangar = insert_in_list(hangar,paretiHangar);
	hangar = insert_in_list(hangar,facciateHangar);


	//PAVIMENTO_ESTERNO
	pavimentoEsterno= read_obj("pavimento_hangar.obj","pavimentoEsterno");
	set_attribute(pavimentoEsterno,cemento);
	set_domain_texture(pavimentoEsterno, cemento, "textures/pavimento.hr",0,0.2,0,0.2,1,0.2,0.3);
	set_translate(pavimentoEsterno,22,0,0);
	set_scale(pavimentoEsterno,1,2,1);

	//ESTERNO
	esterno = create_list(pavimentoEsterno,"esterno");

	//SCENA
	scena = create_list(aereo, "scena");
	scena =	insert_in_list(scena,hangar);
	scena =	insert_in_list(scena,esterno);
	save_scene("b52.md","b52",scena);
	return(0);
}
