%%%%% laxfriedrichs.m
% Lax-Friedrichs Method
% Input:
% f: initial function
% sol: exact solution
% c: velocity
% r: CFL number
% t: time vector
% x: space vector
% N: length of  x
% M: length of  t
% Output:
% lf: numerical approximation
function lf=laxfriedrichs(f,sol,r,t,x,N,M)

lf=zeros(length(t),N);

%initial condition
lf(:,1)=zeros(1,length(t));     

%BC
lf(1,:)=f(x);

for j=1:M-1
   for i=2:N-1
       lf(j+1,i) = (lf(j,i+1)+lf(j,i-1))/2 - r*(lf(j,i+1)-lf(j,i-1))/2;
   end
        figure(6)
        plot(x,sol(j,:),'r');   % plot exact sol
        hold on;
        plot(x,lf(j,:),'bo');    % plot numerical sol
        axis([min(x) max(x) -1.5 1.5])
        legend('exact','numerical');
        title('Wave as function of time -- Lax-Friedrichs')
        pause(0.01);
        hold off;
end
figure(7)
slf=surf(lf);
set(slf,'edgecolor','none')
axis([0 N 0 M -1.5 1.5])
title('Wave as function of time -- Lax-Friedrichs')
