%%%%% laxwendroff.m
% Lax-Wendroff Method
% Input:
% f: initial function
% sol: exact solution
% c: velocity
% r: CFL number
% t: time vector
% x: space vector
% N: length of  x
% M: length of  t
% Output:
% lw: numerical approximation
function lw=laxwendroff(f,sol,r,t,x,N,M)

lw=zeros(length(t),N);

%BC
lw(:,1)=zeros(1,length(t));            

%initial condition
lw(1,:)=f(x);     

for j=1:M-1
   for i=2:N-1
        lw(j+1,i) = lw(j,i) - r*(lw(j,i+1)-lw(j,i-1))/2 + (r^2)*(lw(j,i+1)-2*lw(j,i)+lw(j,i-1))/2;
   end
        figure(4)
        plot(x,sol(j,:),'r');   % plot exact sol
        hold on;
        plot(x,lw(j,:),'bo');    % plot numerical sol
        axis([min(x) max(x) -1.5 1.5])
        legend('exact','numerical');
        title('Wave as function of time -- Lax-Wendroff')
        pause(0.01);
        hold off;
end
figure(5)
slw=surf(lw);
set(slw,'edgecolor','none')
axis([0 N 0 M -1.5 1.5])
title('Wave as function of time -- Lax-Wendroff')