%%%%% upwind.m
% Upwind Method
% Input:
% f: initial function
% sol: exact solution
% c: velocity
% r: CFL number
% t: time vector
% x: space vector
% N: length of  x
% M: length of  t
% Output:
% u: numerical approximation
function u=upwind(f,sol,c,r,t,x,N,M)

u=zeros(length(t),N);

%BC
u(:,1)=zeros(1,length(t));           

%initial condition
u(1,:)=f(x);                    

for j=1:M-1
   for n=2:N-1
            if c>0
                u(j+1,n) = u(j,n) - r*(u(j,n)-u(j,n-1));
            else
                u(j+1,n) = u(j,n) - r*(u(j,n+1)-u(j,n));   
            end
   end
        figure(2)
        plot(x,sol(j,:),'r');   % plot exact solution
        hold on;
        plot(x,u(j,:),'bo');    % plot numerical solution
        axis([min(x) max(x) -1.5 1.5])
        legend('exact','numerical');
        title('Wave as function of time -- Upwind')
        pause(0.01);
        hold off;
end
figure(3)
su=surf(u);
set(su,'edgecolor','none')
axis([0 N 0 M -1.5 1.5])
title('Wave as function of time -- Upwind')
