function [X1,X2,normR,it]=TCG(OpMat1,OpMat2,Prec1,Prec2,X1_0,X2_0,R1_0,R2_0,r1,r2,tol,itmax,tolT,mprint)
%function [X1,X2,normR,it]=TCG(OpMat1,OpMat2,Prec1,Prec2,X1_0,X2_0,R1_0,R2_0,r1,r2,tol,itmax,tolT,mprint)
%
% % Preconditioned matrix-oriented CG method with rank truncation for solving matrix equation
% % A1 X B1' + ... + Am X Bm'  = R1_0 R2_0', 
%
%  The operator must be applied to P=P1*P2'  as 
%  Q1=OpMat1(P1) = [A1*P1, ...., Am*P1];
%  Q2=OpMat2(P2) = [B1*P2, ...., Bm*P2];
%
% The same for the preconditioners Z1=Prec1(P1)=[G1*P1, ...., Gm*P1], Z2=Prec2(P2)=...
%
% Final approximation:    X \approx  X1 *X2'


n=size(X1_0,1); 
it=0;

X1=X1_0;        X2=X2_0;  
R1=R1_0;        R2=R2_0;  
normR0=sqrt(trace((R1_0'*R1_0)*(R2_0'*R2_0)));
normR=1;
Z1=Prec1(R1);   Z2=Prec2(R2);
P1=Z1;          P2=Z2;      

np1=size(P1,2);
Q1=OpMat1(P1);  Q2=OpMat2(P2);
xi=trace((P1'*Q1)*(Q2'*P2));
storer(1)=normR;


while (normR>tol)&&(it<=itmax)


    w=trace((P1'*R1)*(R2'*P2))/xi;

    X1=[X1 sqrt(w)*P1]; X2=[X2 sqrt(w)*P2]; %X1=[X1 P1]; X2=[X2 w*P2];
    [X1,X2]=trunc(X1,X2,r1,tolT,1);

    np1=size(X1,2);
    G1=OpMat1(X1); G2=OpMat2(X2);
    R1=[R1_0, G1];
    R2=[R2_0, -G2];
    normR=sqrt(trace(abs((R1'*R1)*(R2'*R2))))/normR0;
    it=it+1;
    storer(it)=normR;
%   disp([it,normR])
    Z1=Prec1(R1);   Z2=Prec2(R2);
    beta=-trace((Q1'*Z1)*(Z2'*Q2))/xi;

    P1=[Z1 sqrt(beta)*P1]; P2=[Z2 sqrt(beta)*P2]; 
    [P1,P2]=trunc(P1,P2,r2,tolT,1);

    np1=size(P1,2);
    Q1=OpMat1(P1); Q2=OpMat2(P2);
    xi=trace((P1'*Q1)*(Q2'*P2));
  
end
fprintf(' n. iter %d,  rel.res %d\n',it,normR)


if mprint
semilogy(0:length(storer)-1,storer)
xlabel('number of iterations')
ylabel('relative residual norm ')
end
