function [X1,X2]=trunc(A,B,r,tol,type_trunc)
%function [X1,X2]=trunc(A,B,r,tol,type_trunc)

[Q1,R1]=qr(A,0);
[Q2,R2]=qr(B,0);
[U,S,V]=svd(full(R1*R2'),0);

if type_trunc==1
  t=find(cumsum(diag(S))./sum(diag(S))>1-tol,1);
else
  t=find(sqrt(cumsum(diag(S).^2))./norm(diag(S))>1-tol,1);
end
t= min([r t]);

X1=Q1*(U(:,1:t)*sqrt(S(1:t,1:t)));
X2=Q2*(V(:,1:t)*sqrt(S(1:t,1:t)));

end
