function [root, cont] = Bisection(fname,a,b,delta)
%
% Funzione per la risoluzione dell'equazione non lineare  
%                       f(x)=0
% mediante il metodo di BISEZIONE
%
% INPUT: 
%    fname   puntatore alla funzione non lineare 
%            a una sola variabile.
%      a,b   intervallo iniziale [a,b]
%            tale che f e' continua in [a,b] e f(a)f(b) < 0
%    delta   tolleranza (scalare non negativo).
%
% OUTPUT:
%     root   punto medio dell'intervallo [alpha,beta]
%            con la proprieta' che f(alpha)f(beta)<=0 e
%             |beta-alpha| <= delta+eps*max(|alpha|,|beta|)
%             |beta-alpha| <= 2*delta
%             |beta-alpha| <= delta+2.*eps.*abs(beta)
%     cont  numero di iterazioni compiute
%
   fa = fname(a);
   fb = fname(b);
   if fa*fb > 0
      disp('intervallo iniziale che non soddisfa f(a)f(b) < 0.')
	  return
   end
   if nargin==3
      delta = 0.01;
   end
   cont=0;
%   while abs(a-b) > delta+eps*max(abs(a),abs(b))
   while abs(a-b) >= 2*delta
      mid = (a+b)/2;
      fmid = fname(mid);
      if fa*fmid<=0
	     % radice in [a,mid].
         b  = mid; 
         fb = fmid;
      else
	     % radice in [mid,b].
         a  = mid; 
         fa = fmid;
    end  
    cont=cont+1;
    root(cont)=mid;
   end
   root(cont+1) = (a+b)/2;
   %disp('ultimo intervallo calcolato')
   %a,b
