function [x,cont]= newton(fun,jac,x0,ep)
%
% Funzione per la risoluzione del sistema f(x)=0
% mediante il metodo di Newton.
%
% INPUT:
%      fun, jac  nomi dei file contenenti rispettivamente 
%                la funzione non lineare e 
%                la matrice Jacobiana della funzione
%         x0     vettore contenente l'approssimazione iniziale della soluzione
%         ep     parametro di tolleranza per l'errore
% OUTPUT:
%         x      vettore soluzione del sistema (o equazione) non lineare
%       cont     numero di iterazioni fatte per ottenere l'approssimazione
%                desiderata
%

y=feval(jac,x0)\feval(fun,x0);
x=x0-y;
cont=1;
while (norm(x-x0,'inf') > ep) & (cont<100)
   x0=x;
   y=feval(jac,x0)\feval(fun,x0); %sistema lineare
   x = x0 - y;
   cont=cont+1;
end
if cont==100
   disp('Il procedimento non converge con la ');
   disp('precisione desiderata.');
   disp('Dopo 100 passi'); 
   fprintf('\t\t norma = %f .',norm(x-x0,'inf'));
end